/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.swing;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;

public class PImagePanel
extends JComponent {
    private Icon background;

    public PImagePanel(Icon background, LayoutManager layout) {
        this.background = background;
        this.setLayout(layout);
        this.setDoubleBuffered(true);
        this.setOpaque(true);
    }

    public PImagePanel(Icon background) {
        this(background, new FlowLayout());
    }

    public PImagePanel() {
        this(null, new FlowLayout());
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        size.width = Math.max(size.width, this.background.getIconWidth());
        size.height = Math.max(size.height, this.background.getIconHeight());
        return size;
    }

    public Icon getBackgroundIcon() {
        return this.background;
    }

    public void setBackgroundIcon(Icon background) {
        this.background = background;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Rectangle clip = g.getClipBounds();
        g.setColor(this.getBackground());
        g.fillRect(clip.x, clip.y, clip.width, clip.height);
        if (this.background != null) {
            this.background.paintIcon(this, g, 0, 0);
        }
    }
}

